import pandas as pd
import numpy as np
import pickle
from decision_company import read_csv_file, check_elements_in_list, assert_series, logical_and, logical_or, count_unique_values, fill_missing_values, create_dataframe, reset_index

atp_tennis = read_csv_file('atp_tennis.csv')

# Remove any extra spaces from the player names
top_10_player_names = [player[0].strip() for player in top_10_ranked_players_list]

# Filter the dataset to only include grass court matches played by the top 10 players in the last five years
player_1_in_top_10 = check_elements_in_list(recent_matches['Player_1'], top_10_player_names)
player_2_in_top_10 = check_elements_in_list(recent_matches['Player_2'], top_10_player_names)
matches_with_top_10_players = logical_or(player_1_in_top_10, player_2_in_top_10)

matches_on_grass = assert_series(recent_matches['Surface'], 'Grass', 'equality')

grass_matches = recent_matches[logical_and(matches_on_grass, matches_with_top_10_players)]

# Calculate the number of matches played by each player
matches_played = count_unique_values(grass_matches['Player_1']) + count_unique_values(grass_matches['Player_2'])
matches_played = fill_missing_values(matches_played[top_10_player_names],0)

# Calculate the number of matches won by each player
matches_won = count_unique_values(grass_matches['Winner'])
matches_won = fill_missing_values(matches_won[top_10_player_names],0)

# Calculate the win rate percentage for each player
win_rate_percentage = (matches_won / matches_played) * 100

# Create a data table with player names, number of matches played, number of matches won, and win rate percentage
win_rate_table = create_dataframe({'Player': top_10_player_names, 'Matches Played': matches_played, 'Matches Won': matches_won, 'Win Rate Percentage': win_rate_percentage})
win_rate_table = reset_index(win_rate_table)

print(win_rate_table)
pickle.dump(win_rate_table,open("./ref_result/win_rate_table.pkl","wb"))